/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.blockentity.FluidInterfaceBlockEntity;
import com.refinedmods.refinedstorage.blockentity.NetworkNodeBlockEntity;
import com.refinedmods.refinedstorage.container.FluidInterfaceContainerMenu;
import com.refinedmods.refinedstorage.render.FluidRenderer;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.RedstoneModeSideButton;
import com.refinedmods.refinedstorage.util.RenderUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class FluidInterfaceScreen
extends BaseScreen<FluidInterfaceContainerMenu> {
    private static final FluidRenderer TANK_RENDERER = new FluidRenderer(16000, 12, 47, 1);

    public FluidInterfaceScreen(FluidInterfaceContainerMenu containerMenu, Inventory inventory, Component title) {
        super(containerMenu, 211, 204, inventory, title);
    }

    @Override
    public void onPostInit(int x, int y) {
        this.addSideButton(new RedstoneModeSideButton(this, NetworkNodeBlockEntity.REDSTONE_MODE));
    }

    @Override
    public void tick(int x, int y) {
    }

    @Override
    public void renderBackground(PoseStack poseStack, int x, int y, int mouseX, int mouseY) {
        this.bindTexture("refinedstorage", "gui/fluid_interface.png");
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        if (!FluidInterfaceBlockEntity.TANK_IN.getValue().isEmpty()) {
            TANK_RENDERER.render(poseStack, x + 46, y + 56, FluidInterfaceBlockEntity.TANK_IN.getValue());
        }
        if (!FluidInterfaceBlockEntity.TANK_OUT.getValue().isEmpty()) {
            TANK_RENDERER.render(poseStack, x + 118, y + 56, FluidInterfaceBlockEntity.TANK_OUT.getValue());
        }
    }

    @Override
    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY) {
        this.renderString(poseStack, 7, 7, this.f_96539_.getString());
        this.renderString(poseStack, 47, 20, I18n.m_118938_((String)"gui.refinedstorage.fluid_interface.in", (Object[])new Object[0]));
        this.renderString(poseStack, 116, 20, I18n.m_118938_((String)"gui.refinedstorage.fluid_interface.out", (Object[])new Object[0]));
        this.renderString(poseStack, 7, 111, I18n.m_118938_((String)"container.inventory", (Object[])new Object[0]));
        if (RenderUtils.inBounds(46, 56, 12, 47, mouseX, mouseY) && !FluidInterfaceBlockEntity.TANK_IN.getValue().isEmpty()) {
            this.renderTooltip(poseStack, mouseX, mouseY, FluidInterfaceBlockEntity.TANK_IN.getValue().getDisplayName().getString() + "\n" + ChatFormatting.GRAY + API.instance().getQuantityFormatter().formatInBucketForm(FluidInterfaceBlockEntity.TANK_IN.getValue().getAmount()) + ChatFormatting.RESET);
        }
        if (RenderUtils.inBounds(118, 56, 12, 47, mouseX, mouseY) && !FluidInterfaceBlockEntity.TANK_OUT.getValue().isEmpty()) {
            this.renderTooltip(poseStack, mouseX, mouseY, FluidInterfaceBlockEntity.TANK_OUT.getValue().getDisplayName().getString() + "\n" + ChatFormatting.GRAY + API.instance().getQuantityFormatter().formatInBucketForm(FluidInterfaceBlockEntity.TANK_OUT.getValue().getAmount()) + ChatFormatting.RESET);
        }
    }
}

